var Keyboard = {
	callback : null,
	isInit : false,
	visible : false,
	shift : false,
	
	str : '',
	
	x : 0, 
	y : 0, 
	
	mode : 0,
	modeArr : ['en','ru'],
	keysCode : []
};

// en letters
Keyboard.keysCode[0] = new Array();
Keyboard.keysCode[0][0] = new Array(33,35,36,38,42,40,41,95,43,34,94,37,64,123,125);
Keyboard.keysCode[0][1] = new Array(39,49,50,51,52,53,54,55,56,57,48,45,61,8,8);
Keyboard.keysCode[0][2] = new Array(0,113,119,101,114,116,121,117,105,111,112,91,93,13,13);
Keyboard.keysCode[0][3] = new Array(10,97,115,100,102,103,104,106,107,108,58,39,126,13,13);
Keyboard.keysCode[0][4] = new Array(1,124,122,120,99,118,98,110,109,44,46,47,63,9,9);
Keyboard.keysCode[0][5] = new Array(2,3,4,32,32,32,32,32,32,32,32,5,6,7,8);

// ru letters
Keyboard.keysCode[1] = new Array();
Keyboard.keysCode[1][0] = new Array(33,35,36,38,42,40,41,95,43,34,94,37,64,123,125);
Keyboard.keysCode[1][1] = new Array(39,49,50,51,52,53,54,55,56,57,48,45,61,8,8);
Keyboard.keysCode[1][2] = new Array(39,0x439,0x446,0x443,0x43a,0x435,0x43d,0x433,0x448,0x449,0x437,0x445,0x44a,13,13);
Keyboard.keysCode[1][3] = new Array(10,0x444,0x44b,0x432,0x430,0x43f,0x440,0x43e,0x43b,0x434,0x436,0x44d,126,13,13);
Keyboard.keysCode[1][4] = new Array(0x7c,0x5c,0x44f,0x447,0x441,0x43c,0x438,0x442,0x44c,0x431,0x44e,47,63,46,46);
Keyboard.keysCode[1][5] = new Array(2,0x3a,0x3b,32,32,32,32,32,32,32,32,91,93,0x2c,0x2c);

Keyboard.init = function() 
{
	// Add keyboard html code
	if($("#keyboard").length == 0){
		$("body").append('<div id="keyboard" />');
		$("#keyboard").append('<div id="keyboard-keys" class="'+this.modeArr[this.mode]+'" />');
		$("#keyboard").append('<div id="keyboard-pointer" />');
		$("#keyboard").append('<div id="keyboard-shift" />');
	}
	
	// Voice recognition			
	if(typeof deviceapis != 'undefined' && 
	   typeof deviceapis.recognition.IsRecognitionSupported != 'undefined' && 
	   deviceapis.recognition.IsRecognitionSupported()) 
	{
		deviceapis.recognition.SubscribeExEvent(deviceapis.recognition.PL_RECOGNITION_TYPE_VOICE, "FS_TO", this.handleRecognitionEvent);
		deviceapis.recognition.SetVoiceHelpbarInfo(JSON.stringify({
			helpbarType: "HELPBAR_TYPE_VOICE_SERVER_GUIDE",
			guideText: "Произнесите слово или фразу, которые нужно ввести."
		}));
		deviceapis.recognition.SetVoiceTimeout(5000);
	}
	
	this.isInit = true;
};

Keyboard.deinit = function() 
{
	this.mode = 0;
	this.visible = false;
	
	$("#keyboard").remove();
	
	if(typeof deviceapis != 'undefined') {
		deviceapis.recognition.UnsubscribeExEvent(deviceapis.recognition.PL_RECOGNITION_TYPE_VOICE, 'FS_TO');
	}
}

Keyboard.handleRecognitionEvent = function(event)
{
	if(typeof deviceapis != 'undefined') {
		switch (event.eventtype) {
			case "EVENT_VOICE_BEGIN_MONITOR":
			case "EVENT_VOICE_BTSOUND_START":
				break;
			case "EVENT_VOICE_RECOG_RESULT":
				Keyboard.str = event.result;
				Keyboard.setText(Keyboard.str);
				deviceapis.recognition.HideVoiceHelpbar();
				break;
		}
	}
}

Keyboard.show = function() 
{

	if(!this.isInit) {
		this.init();
	}
	
	this.visible = true;
	this.shift = false;

	this.str = $(".plainText").val();

	this.x = 6;
	this.y = 2;

	this.setPosition(this.x, this.y);
	this.blink(true);

	$("#keyboard").show();

	return true;
};

Keyboard.hide = function() 
{
	this.visible = false;
	
	$("#keyboard").hide();
	$(".plainText").val(this.str);

	return false;
};

Keyboard.setCallback = function(callback) 
{
	this.callback = callback;
}

Keyboard.setMode = function(mode) 
{
	var modeId, modeClass;

	if(is_numeric(mode)) {
		modeId	  = mode;
		modeClass = this.modeArr[modeId];
	} else {
		modeId	  = this.modeArr.indexOf(mode);
		modeClass = mode;
	}
	
	this.mode = modeId;
	
	$("#keyboard-keys").attr("class", modeClass);
	
	return true;
}

Keyboard.setPosition = function(x,y) 
{
	var xPos;
	var yPos;
	var Xo=0;
	var Yo=45;
	
	switch(y) {
		case 0:
			xPos = Xo + x * 53;
			break;
	 
		case 1:
			if( x >= 13) {
				xPos = Xo + 715;
			} else {
				xPos = Xo + x * 53;
			}
			break;
 
		case 2:
			if(x==0) {
				xPos = Xo + 10;
			} else if ( x >= 13) {
				xPos = Xo + 740;
			} else {
				xPos = Xo + 24 + x * 53;
			}
			break;
				
		case 3:
			if ( x == 0) {
				xPos = Xo + 22;
			} else if (x >= 13) {
				xPos = Xo + 740;
			} else {
				xPos = Xo + 53 + x * 53;
			}
			break;
			   
		case 4:
			if (x == 0) {
				xPos = Xo + 10;
			} else if (x >= 13) {
				xPos = Xo + 720;
			} else {
				xPos = Xo + 24 + x * 53;
			}
			break;
				
		case 5:
			if (x == 0) {
				xPos = Xo + 10;
			} else if (x >= 3 && x <= 10) {
				xPos = Xo + 370;
			} else if (x >= 13) {
				xPos = Xo + 720;
			} else {
				xPos = Xo + 24 + x * 53;
			}
			break;
	}
	
	if((y == 2 || y == 3) && x >= 13){
		yPos = 170;
	} else {
		yPos = Yo + y * 54;
	}
	
	$("#keyboard-pointer").css("left",xPos+"px");
	$("#keyboard-pointer").css("top",yPos+"px");  
};

Keyboard.setRight = function() 
{
	if (this.x < 14) {
		if (this.y == 5 && (this.x >= 3 && this.x <= 10)) {
			this.x = 11;
		} else {
			this.x++;
		}
		
		this.setPosition(this.x,this.y);
	}
};

Keyboard.setLeft = function() 
{
	if (this.x > 0) {
		if(this.y != 0 && this.x > 13){
			this.x -= 2;
		} else if (this.y == 5 && (this.x >= 3 && this.x <= 10)) {
			this.x = 2;
		} else {
			this.x--;
		}
		
		this.setPosition(this.x,this.y);
	}
}; 
    
Keyboard.setDown = function() 
{
	if (this.y < 5) {
		if (this.y == 2 && this.x >= 13) {
			this.y += 2;
		} else if (this.y == 4 && (this.x >= 3 && this.x <= 10)) {
			this.x = 6;
			this.y++;
		} else {
			this.y++;
		}
		
		this.setPosition(this.x,this.y);
	}
};
    
Keyboard.setUp = function() 
{
	if (this.y > 0) {
		if (this.y == 3 && this.x >= 13) {
			this.y -= 2;
		} else if (this.y == 5 && (this.x >= 3 && this.x <= 10)) {
			this.x = 6;
			this.y--;
		} else {
			this.y--;
		}
		
		this.setPosition(this.x,this.y);
	}
};

Keyboard.blink = function(c) 
{
	if(this.visible) {
		if (c) {
			this.setText(this.str);

			if (this.visible) {
				setTimeout("Keyboard.blink(false);", 500);
			}
		} else {
			this.setText(this.str, '_');

			if (this.visible) {
				setTimeout("Keyboard.blink(true);", 500);
			}
		}
	}
};

Keyboard.setText = function(str, postfix) 
{
	if(typeof postfix == 'undefined') {
		postfix = '';
	}
	
	var l = str.length;
	var m = $('.plainText').attr('size');
		
	if (l > m) {
		$(".plainText").val("..." + str.substr(l - m) + postfix);
	} else {
		$(".plainText").val(str + postfix);
	}
};

Keyboard.shiftChange = function() 
{
	this.shift = !this.shift;
	
	if(this.shift) {
		$("#keyboard-shift").addClass("active");
	} else {
		$("#keyboard-shift").removeClass("active");
	}
};

Keyboard.changeMode = function() 
{
	if(this.mode < this.modeArr.length - 1) {
		this.mode++;
	} else {
		this.mode = 0;
	}
	
	this.setMode(this.mode);
};

Keyboard.addKey = function() 
{
	var keyCode;
    var char = '';
	
	keyCode = Keyboard.keysCode[this.mode][this.y][this.x];
	
	if (keyCode == 0) {
		char = ".com";
	} 
	
	else if (keyCode == 1) {
		char = ".net";
	} 
	
	else if (keyCode == 2) {
		this.mode = (this.mode > 0) ? 0 : 1;
		this.setMode(this.mode);
		return;
	} 
	
	else if (keyCode == 3) {
		char = ".de";
	} 
	
	else if (keyCode == 4) {
		char = ".uk";
	} 
	
	else if (keyCode == 5) {
		char = ".cz";
	} 
	
	else if (keyCode == 6) {
		char = ".pl";
	} 
	
	else if (keyCode == 7) {
		char = ".xml";
	} 
	
	else if (keyCode == 8) {
		this.backSpace();
		return;
	} 
	
	else if (keyCode == 9) {
		char = "www.";
	} 
	
	else if (keyCode == 10) {
		this.shiftChange();
		return;
	} 
	
	else if (keyCode == 13) {
		var str = $(".plainText").val();
		var last_char = str.charAt(str.length - 1);

		if(last_char == "_"){
			$(".plainText").val(str.slice(0, -1));
		}
		
		this.callback(this.str);
		
		return;
	} 
	
	else if (keyCode > 31) {
		char = String.fromCharCode(keyCode);
	}
	
	if(this.shift) {
		char = char.toUpperCase();
	}

	this.str += char;

	this.setText(this.str);
};

Keyboard.backSpace = function() 
{
    this.str = this.str.substr(0, this.str.length - 1);
	this.setText(this.str);
};

Keyboard.clear = function() 
{
    this.str = '';
	this.setText(this.str);
};  

Keyboard.returnKey = function() 
{
	Search.textobjKeyFunc();
};
