var Favorites = {
	items: new Array(),
	isVisible: false,
	kolPages: 1,
};

Favorites.open = function() {
	Favorites.readAll();
	Main.clearBlocks();
	Main.page = 1;
	Display.help_line_4();
	this.menuIndex = false;
	Main.search = false;
	this.isVisible = true;
	Favorites.favoritPage();
	Favorites.showItems();
};

Favorites.addLine = function() {
	var obj = new Object();		
	obj.url = URLtoXML.UrlSt[Main.index];
	obj.name = URLtoXML.sName[Main.index];
	obj.img = URLtoXML.ImgDickr[Main.index];
	var isAdd = true;
	for(var i=0; i<this.items.length && isAdd; i++)
		if (this.items[i].url==obj.url)
			isAdd = false;
	if (isAdd) this.items[this.items.length] = obj;
};

Favorites.writeAll = function() {
	var fileSystemObj = new FileSystem();
	if (!fileSystemObj.isValidCommonPath(curWidget.id)) fileSystemObj.createCommonDir(curWidget.id);
    var fileObj = fileSystemObj.openCommonFile(curWidget.id+'/kinokong.data','w');
    if (fileObj)
    {
        var str = JSON.stringify(this.items);
		fileObj.writeAll(str);
        fileSystemObj.closeCommonFile(fileObj);
    }
};

Favorites.readAll = function() {	
	var fileSystemObj = new FileSystem();
	var fileObj = fileSystemObj.openCommonFile(curWidget.id+'/kinokong.data','r');
	if (fileObj){
		var strResult = fileObj.readAll();
		if (strResult)
			this.items = JSON.parse(strResult);
		fileSystemObj.closeCommonFile(fileObj);
	}
	kolPages = Math.round(this.items/12);
};

Favorites.showItems = function() {
	if (this.items.length>0)
		for (var i=Main.page*12; i<this.items.length && i<(Main.page+1)*12+1; i++){
			
			URLtoXML.ImgDickr[i+1-Main.page*12] = this.items[i].img;
			URLtoXML.UrlSt[i+1-Main.page*12] = this.items[i].url;
			URLtoXML.sName[i+1-Main.page*12] = this.items[i].name;
			URLtoXML.pDes[i+1-Main.page*12] = '';
			
			if (URLtoXML.sName[Main.index]){
				widgetAPI.putInnerHTML(document.getElementById("title"), URLtoXML.sName[Main.index])
			}else{
				widgetAPI.putInnerHTML(document.getElementById("title"), '')
			}
			widgetAPI.putInnerHTML(document.getElementById("bloc" + (i+1-Main.page*12)), "<img class='blockImage' id='imgst" + (i+1-Main.page*12) +  "';  src='" + URLtoXML.ImgDickr[i+1-Main.page*12] + "' />");
			if (document.getElementById("imgst" + Main.index))
				document.getElementById("imgst" + Main.index).style.borderColor = "#3399FF"; 
		}
};

Favorites.add  = function(){
	Favorites.readAll();
	Favorites.addLine();
	Favorites.writeAll();
	Display.statusLine("\u0414\u043E\u0431\u0430\u0432\u043B\u0435\u043D\u043D\u043E \u0432 \u0438\u0437\u0431\u0440\u0430\u043D\u043D\u043E\u0435");
};

Favorites.del = function(){
	Favorites.readAll();
	Favorites.delLine();
	Favorites.writeAll();
	Main.clearBlocks();
	Favorites.showItems();
	Display.statusLine("\u0423\u0434\u0430\u043B\u0435\u043D\u043E \u0438\u0437 \u0438\u0437\u0431\u0440\u0430\u043D\u043D\u043E\u0433\u043E");
};

Favorites.delLine = function(){
	this.items.splice(Main.index+Main.page*12-1, 1);
	if (this.items.length<=(Main.page*12) && Main.page>0) Main.page--;
};

Favorites.changePage = function() {
	var idx = Main.index;
	Main.clearBlocks();
	Main.index = idx;
	Favorites.showItems();
	if (this.items.length>(Main.page*12)){
		return 1;
	}else{
		if (Main.page>0) Main.page--;
		Favorites.showItems();
		return 0;
	}
}
Favorites.favoritPage = function() {
	Main.page = 0;
	$("#menu").html("");
	$("#menu").append('<span>\u0418\u0437\u0431\u0440\u0430\u043D\u043D\u043E\u0435</span>');
};
